" ExternalEdit MoinMoin action module"
# imports
import cgi, os, string, sys
from MoinMoin import  webapi, i18n
from MoinMoin.PageEditor import PageEditor
from MoinMoin.i18n import _ # XXX


STANDARD_SAVE_OPTION_ITEMS = {'notify': [_('Send mail notification'), _('No')],
                             'stripspaces': [_('Remove trailing whitespace from each line'), _('No')], 
                             'comment': [_('Comment'),'']}

def ExternalEdit(pagename, request):
    page = PageEditor(pagename)
    # Check what subaction we need to do, if save or send 
    if request.form.has_key('save'):
        savePage(page, request)
    else:
        sendPage(page, request)
	# raise SystemExit to avoid having superfluous HTML appended,
	# like moin timings or version info
	raise SystemExit


def savePage(page,request):
    """ save the page edited by user using the helper app"""
    # Check if user has the permissions to edit file 
    if not request.user.may.edit(page.page_name):
        webapi.http_headers(request)
        request.write('result:failure\n')
        request.write('message:%s\n' % _('You do not have the rights to edit this page!'))
    else:
        options = getSaveOptions()
        text = sys.stdin.read()
        page.save_text(request, text, '0', **options)
        webapi.http_headers(request)
        request.write('result:successful\n')
        request.write('message:%s\n' % _('Page saved.'))


def sendPage(page, request):
    # Check if user has the permissions to edit file 
    if not request.user.may.edit(page.page_name):
        page.send_editor(request)
    else:
        headers = ['Content-Type: application/x-moin-edit',
                   'Pragma: no-cache']
        put_headers = ['action=ExternalEdit','save=true']
        out_lines = ''
        ## First add metadata from the helper app
        metadata = []
        # Content type for the helper app
        metadata.append('content_type:application/x-www-form-urlencoded')
        # url to post the edits to
        url = '%s%s?%s' % (webapi.getQualifiedURL(), page.url(),
                           string.join(put_headers, '&amp;'))
        metadata.append('url:%s' % url)
        # cookie
        metadata.append('cookie:%s' % request.user.getCookie()[12:])
        metadata.append('meta_type:moinwiki')
        metadata.append('language:%s' % i18n.getLang())
        out_lines += string.join(metadata, '\n')  + '\n' #trailing newline
        ## Second, get the file
        body = page.get_raw_body()
        ## Third, add edit options to file
        body = addSaveOptions(body)
        out_lines += '\n'
        out_lines += body
        headers.append('Content-Length: %s' % len(out_lines))
        ## Fourth, send all to helper app
        webapi.http_headers(request, headers)
        request.write(out_lines)
    

def washComment(comment):
    """ grabbed from wikiaction.do_savepage, washes the comment option  """
    # delete any unwanted stuff, replace CR, LF, TAB by whitespace
    control_chars = '\x00\x01\x02\x03\x04\x05\x06\x07\x08\x0b\x0c\x0e\x0f' \
                    '\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f'
    remap_chars = string.maketrans('\t\r\n', '   ')
    comment = string.translate(comment, remap_chars, control_chars)
    return comment
    

def addSaveOptions(text, optdic = STANDARD_SAVE_OPTION_ITEMS):
    """ Adds standard MoinMoin edit options to the file sent to user """
    opttext = ''
    for value in optdic.values():
        opttext += '%s: %s\n' % (value[0], value[1]) 
    opttext += '\n'
    opttext += text
    return opttext
        
def getSaveOptions(inputfile = sys.stdin, optdic = STANDARD_SAVE_OPTION_ITEMS):
    """ Parses save options from user saved file """
    parseddic = {}
    while 1:
        line = inputfile.readline()[:-1]
        if not line: break
        sep = line.find(':')
        key = line[:sep].strip()
        val = line[sep+1:].strip()
        for option in optdic.items():
            optquery = option[1][0]
            optanswer = option[1][1]
            optkey = option[0]
            if key == optquery:
                if optkey == 'comment':
                    val = washComment(val)
                    parseddic['comment'] = val
                else:                    
                    if string.lower(val) == string.lower(optanswer):
                        val = ''
                    parseddic[optkey] = val
    return parseddic
        

def execute(pagename, request):
    ExternalEdit(pagename, request)

