#############################################################
#
# empcd
#
#############################################################
EMPCD_VERSION:=2007.11.26
EMPCD_SOURCE:=empcd_$(EMPCD_VERSION).tar.bz2

EMPCD_SITE:=http://prak.org/~henrik/empcd
EMPCD_DIR:=$(BUILD_DIR)/empcd-$(EMPCD_VERSION)

EMPCD_BINARY:=empcd
EMPCD_TARGET_BINARY:=usr/sbin/empcd

MPDCLIENT_LIB_VERSION:=0.13.0
MPDCLIENT_LIB_SITE:=http://musicpd.org/uploads/files/
MPDCLIENT_LIB:=libmpdclient-$(MPDCLIENT_LIB_VERSION).tar.bz2
#
# download source
#
$(DL_DIR)/$(EMPCD_SOURCE):
	 $(WGET) -P $(DL_DIR) $(EMPCD_SITE)/$(EMPCD_SOURCE) 

$(DL_DIR)/$(MPDCLIENT_LIB):
	 $(WGET) -P $(DL_DIR) $(MPDCLIENT_LIB_SITE)/$(MPDCLIENT_LIB) 

#
# unpack source and potentially patch package; use bzcat for bz2 files
#
$(EMPCD_DIR)/.unpacked: $(DL_DIR)/$(EMPCD_SOURCE) $(DL_DIR)/$(MPDCLIENT_LIB)
	bzcat $(DL_DIR)/$(EMPCD_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	mv $(BUILD_DIR)/empcd $(EMPCD_DIR)
	toolchain/patch-kernel.sh $(EMPCD_DIR) package/mpd \
		empcd-\*.patch
	bzcat $(DL_DIR)/$(MPDCLIENT_LIB) | tar -C $(EMPCD_DIR)/support -xf -
	touch $@

# configure source, add additional options to configure as required
# call ./configure --help to find out about additional options
#
$(EMPCD_DIR)/.configured: $(EMPCD_DIR)/.unpacked
	touch  $@

#
# build package
# 
$(EMPCD_DIR)/$(EMPCD_BINARY): $(EMPCD_DIR)/.configured
	$(MAKE) -C $(EMPCD_DIR) CC=$(TARGET_CC) EXTRA="$(TARGET_CONFIGURE_CFLAGS)"

#
# install package
#
$(TARGET_DIR)/$(EMPCD_TARGET_BINARY): $(EMPCD_DIR)/$(EMPCD_BINARY)
	$(FAKEROOT) $(MAKE) -C $(EMPCD_DIR) DESTDIR=$(TARGET_DIR) install
	$(STRIP) $@	
#
# to get empcd, we need $(TARGET_DIR)/usr/sbin/empcd
#   - to get $(TARGET_DIR)/usr/sbin/empcd, we need $(EMPCD_DIR)/empcd
#      - before trying to build empcd, we need
#        $(EMPCD_DIR)/.configured
#        ...
empcd: $(TARGET_DIR)/$(EMPCD_TARGET_BINARY)

empcd-source: $(DL_DIR)/$(EMPCD_SOURCE)

empcd-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(EMPCD_DIR) uninstall
	-$(MAKE) -C $(EMPCD_DIR) clean

empcd-dirclean:
	rm -rf $(EMPCD_DIR)

#############################################################
#
# Toplevel Makefile options
#
#############################################################
# ifeq ($(strip $(BR2_PACKAGE_EMPCD)),y)
TARGETS+=empcd
# endif
